﻿namespace Microsoft.Samples.PlanMyNight.Data
{
    using System;
    using System.Collections.Generic;
    using Microsoft.Samples.PlanMyNight.Entities;

    public interface IItinerariesRepository
    {
        PagingResult<Itinerary> SearchByActivity(string activityId, int pageSize, int pageNumber);

        PagingResult<Itinerary> SearchByZipCode(int activityTypeId, string zip, int pageSize, int pageNumber);

        PagingResult<Itinerary> SearchByCity(int activityTypeId, string state, string city, int pageSize, int pageNumber);

        PagingResult<Itinerary> SearchByRadius(int activityTypeId, double longitude, double latitude, double radius, int pageSize, int pageNumber);

        Itinerary Retrieve(long itineraryId);

        IEnumerable<Itinerary> RetrieveByUser(Guid userId);

        void Add(Itinerary itinerary);

        void Update(Itinerary itinerary);

        string GetUserDisplayName(Guid userId);

        bool CanUserRateItinerary(long itineraryId, Guid userId);

        void RateItinerary(long itineraryId, Guid userId, byte rating, DateTime timestamp);

        IEnumerable<ItineraryComment> RetrieveComments(long itineraryId);

        void AddComment(ItineraryComment comment);
    }
}
